IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_PROD_ARV_MERCADOLOGICA_EXPORTACAO]'))
	DROP VIEW [dbo].[V_EST_PROD_ARV_MERCADOLOGICA_EXPORTACAO]
GO
  
--select TOP 10 * from V_EST_PROD_ARV_MERCADOLOGICA_EXPORTACAO
CREATE VIEW [dbo].[V_EST_PROD_ARV_MERCADOLOGICA_EXPORTACAO]
AS 
SELECT     
		P.CD_EMP, 
		P.CD_PROD, 
		P.DS_PROD, 
		P.DS_USUAL, 
		FAB.CD_FABRIC, 
		FAB.NM_FABRIC, 
		CAT.CD_ARV_MERC_CATEG, 
		CAT.DS_ARV_MERC_CATEG, 
		D.CD_ARV_MERC_DEPTO, 
		D.DS_ARV_MERC_DEPTO, 
		AA.CD_ARV_MERC_AREA_ATEND, 
		AA.DS_ARV_MERC_AREA_ATEND, 
		S.CD_ARV_MERC_SEG, 
		S.DS_ARV_MERC_SEG, 
		L.CD_ARV_MERC_LINHA, 
		L.DS_ARV_MERC_LINHA, 
		L.DS_SIGLA_LINHA, 
		MC.CD_MC, 
		MC.DS_MC, 
		C.CD_ARV_MERC_CONSUMO, 
		C.DS_ARV_MERC_CONSUMO, 
		M.CD_ARV_MERC_MIX, 
		M.DS_ARV_MERC_MIX, 
		PA.CD_ARV_MERC_PAPEL, 
		PA.DS_ARV_MERC_PAPEL, 
		F.CD_ARV_MERC_FAMILIA, 
		F.DS_ARV_MERC_FAMILIA, 
		MTZ.CD_ARV_MERC_MTZ_BCG, 
		MTZ.DS_ARV_MERC_MTZ_BCG, 
		P.CD_UN_VD, 
		P.STS_PROD, 
		P.LISTA_PROD, 
		CASE P.LISTA_PROD WHEN 0 THEN 
				'POSITIVA' 
			WHEN 1 THEN 
				'NEGATIVA' 
			WHEN 2 THEN 
				'NEUTRA' END AS LISTA, 

		P.CTR_PMC, 
		P.COMPRIMENTO, 
		P.LARGURA, 
		P.ALTURA, 
		P.PERC_DESC_FIDEL, 
		P.PERC_DESC_FIDEL_MAX, 
	 
		CASE WHEN P.COMPRA_POR_SUPRIMENTO = 0 THEN 
				'RESSUPRIMENTO'
			WHEN P.COMPRA_POR_SUPRIMENTO = 1 THEN 
				'SUPRIMENTO'
			WHEN P.COMPRA_POR_SUPRIMENTO = 2 THEN 
				 'SUP-RESSUP' END AS TIPO_COMPRA, 
		P.VLR_COMPRA_GRP, 
		P.PROD_USO_CONT,
		P.NR_NCM,
		EQ.CD_ARV_MERC_EQUI,
		EQ.DS_ARV_MERC_EQUI,
		AP.CD_APRES,
		AP.DS_APRES,
		P.FLAG_ANALISE_FALTAS,
		P.CTR_LOTE,
		p.VLR_CUSTO_GRP,
		CAT.NR_ITEM_CTB,
		fab.PARAM_EST,
		fab.LEAD_TIME,
		P.VLR_PRECO_OPERADOR_LOG,
		P.COMPRA_POR_SUPRIMENTO,
		p.FLAG_PRODUTO_TAXA_ENTREGA,
		P.FLAG_PRODUTO_BLISTER,
		P.FLAG_TROCA_FORNECEDOR,
		L.FLAG_NAO_PARTIC_INDIC FLAG_NAO_PARTIC_INDIC_LINHA,
		P.DT_CAD,
		P.FLAG_PRODUTO_CONTROLADO,
		P.FLAG_ANALISE_EXC_COB,
		P.APRES_QT_CP,
		EXPO.CD_GRP_EXPO AS CD_GRP_EXPO,
		EXPO.DS_GRP_EXPO AS DS_GRP_EXPO,
		EST_TRIB_CLASS_FISC.DS_CLASS_FISC,
		CLASS.CD_ARV_MERC_CLASSIFICACAO,
		CLASS.DS_ARV_MERC_CLASSIFICACAO,
		FASE.CD_ARV_MERC_FASE,
		FASE.DS_FASE,
		GENERO.CD_ARV_MERC_GENERO,
		GENERO.DS_GENERO,
		isnull(b.CD_BARRA,'') as CD_BARRA,
		CATSUB.CD_ARV_MERC_CATEG_SUB, 
		CATSUB.DS_ARV_MERC_CATEG_SUB 
FROM         
		dbo.EST_PROD AS P 

		INNER JOIN	dbo.EST_PROD_EST_ARV_MERCADOLOGICA AS ARV ON 
		P.CD_EMP = ARV.CD_EMP AND 
		P.CD_PROD = ARV.CD_PROD 

		INNER JOIN dbo.EST_PROD_FABRIC AS FAB ON 
		P.CD_FABRIC = FAB.CD_FABRIC 
		
		INNER JOIN	dbo.EST_MC AS MC ON 
		ARV.CD_EMP = MC.CD_EMP AND 
		ARV.CD_MC = MC.CD_MC

		INNER JOIN	dbo.EST_ARV_MERC_CATEGORIA AS CAT ON 
		ARV.CD_EMP = CAT.CD_EMP AND 
		ARV.CD_ARV_MERC_CATEG = CAT.CD_ARV_MERC_CATEG 
	
		INNER JOIN	dbo.EST_ARV_MERC_DEPTO AS D ON 
		CAT.CD_EMP = D.CD_EMP AND 
		CAT.CD_ARV_MERC_DEPTO = D.CD_ARV_MERC_DEPTO 

		INNER JOIN DBO.EST_ARV_MERC_CLASSIFICACAO AS CLASS ON
		ARV.CD_EMP = CLASS.CD_EMP AND 
		ARV.CD_ARV_MERC_CLASSIFICACAO = CLASS.CD_ARV_MERC_CLASSIFICACAO

		INNER JOIN DBO.EST_ARV_MERC_FASE AS FASE ON
		ARV.CD_EMP = FASE.CD_EMP AND 
		ARV.CD_ARV_MERC_FASE = FASE.CD_ARV_MERC_FASE

		INNER JOIN DBO.EST_ARV_MERC_GENERO AS GENERO ON
		ARV.CD_EMP = GENERO.CD_EMP AND 
		ARV.CD_ARV_MERC_GENERO = GENERO.CD_ARV_MERC_GENERO

		INNER JOIN dbo.EST_ARV_MERC_AREA_ATENDIMENTO AS AA ON 
		D.CD_EMP = AA.CD_EMP AND 
		D.CD_ARV_MERC_AREA_ATEND = AA.CD_ARV_MERC_AREA_ATEND 

		INNER JOIN dbo.EST_ARV_MERC_SEGMENTO AS S ON 
		ARV.CD_EMP = S.CD_EMP AND 
		ARV.CD_ARV_MERC_SEG = S.CD_ARV_MERC_SEG 

		INNER JOIN	dbo.EST_ARV_MERC_LINHA AS L ON 
		ARV.CD_EMP = L.CD_EMP AND 
		ARV.CD_ARV_MERC_LINHA = L.CD_ARV_MERC_LINHA 

		INNER JOIN		dbo.EST_ARV_MERC_CONSUMO AS C ON 
		ARV.CD_EMP = C.CD_EMP AND 
		ARV.CD_ARV_MERC_CONSUMO = C.CD_ARV_MERC_CONSUMO 

		INNER JOIN	dbo.EST_ARV_MERC_MIX AS M ON 
		ARV.CD_EMP = M.CD_EMP AND 
		ARV.CD_ARV_MERC_MIX = M.CD_ARV_MERC_MIX 

		INNER JOIN	dbo.EST_ARV_MERC_PAPEL AS PA ON 
		ARV.CD_EMP = PA.CD_EMP AND 
		ARV.CD_ARV_MERC_PAPEL = PA.CD_ARV_MERC_PAPEL 

		INNER JOIN	dbo.EST_ARV_MERC_FAMILIA AS F ON 
		ARV.CD_EMP = F.CD_EMP AND 
		ARV.CD_ARV_MERC_FAMILIA = F.CD_ARV_MERC_FAMILIA 

		INNER JOIN	dbo.EST_ARV_MERC_MTZ_BCG AS MTZ ON 
		ARV.CD_EMP = MTZ.CD_EMP AND 
		ARV.CD_ARV_MERC_MTZ_BCG = MTZ.CD_ARV_MERC_MTZ_BCG

		INNER JOIN	dbo.EST_ARV_MERC_EQUIVALENTE AS EQ ON 
		ARV.CD_EMP = EQ.CD_EMP AND 
		ARV.CD_ARV_MERC_EQUI = EQ.CD_ARV_MERC_EQUI

		INNER JOIN	dbo.EST_ARV_MERC_APRESENTACAO AS AP ON 
		ARV.CD_EMP = AP.CD_EMP AND 
		ARV.CD_APRES = AP.CD_APRES

		INNER JOIN EST_GRP_EXPO AS EXPO ON
		ARV.CD_EMP = EXPO.CD_EMP AND
		ARV.CD_GRP_EXPO = EXPO.CD_GRP_EXPO
    
		INNER JOIN EST_TRIB_CLASS_FISC ON
		p.CD_CLASS_FISC = EST_TRIB_CLASS_FISC.CD_CLASS_FISC

		LEFT OUTER JOIN EST_PROD_CD_BARRA b ON
		p.CD_EMP = b.CD_EMP AND
		p.CD_PROD =b.CD_PROD  

		INNER JOIN	dbo.EST_ARV_MERC_CATEGORIA_SUB AS CATSUB ON 
		ARV.CD_EMP = CATSUB.CD_EMP AND 
		ARV.CD_ARV_MERC_CATEG = CATSUB.CD_ARV_MERC_CATEG AND
		ARV.CD_ARV_MERC_CATEG_SUB = CATSUB.CD_ARV_MERC_CATEG_SUB